CREATE TABLE CRM_Turnos_Pre_Tipos(
	Id_Turno_Pre_Tipo	SMALLINT IDENTITY(1,1) NOT NULL,
	Descripcion			VARCHAR(100),
	Prefijo				VARCHAR(4),
	CONSTRAINT PK_CTurPT_PorId PRIMARY KEY CLUSTERED (Id_Turno_Pre_Tipo)
)
GO

CREATE UNIQUE INDEX IX_CTurPT_PorDesc ON CRM_Turnos_Pre_Tipos
	(Descripcion ASC)
GO

----------------------------------------------------------------------------------

CREATE TABLE CRM_Turnos_Pre_Dispositivos(
	Id_Turno_Pre_Disp	SMALLINT IDENTITY(1,1) NOT NULL,
	Descripcion			VARCHAR(100),
	Tipo				VARCHAR(10),         --BOX | TOTEN | MONITOR   
	Id_Sector			SMALLINT,
	PC					VARCHAR(100),
	CONSTRAINT PK_CTurPB_PorId PRIMARY KEY CLUSTERED (Id_Turno_Pre_Disp)
)
GO

CREATE INDEX IX_CTurPB_PorDesc ON CRM_Turnos_Pre_Dispositivos
	(Descripcion ASC)
GO

CREATE UNIQUE INDEX IX_CTurPB_PorSec ON CRM_Turnos_Pre_Dispositivos
	(Id_Sector ASC)
GO


ALTER TABLE CRM_Turnos_Pre_Dispositivos		
	ADD CONSTRAINT FK_CTurPB_Sectores FOREIGN KEY(Id_Sector)
	REFERENCES Empresas_Sedes_Sectores (Id_Sector)
GO

----------------------------------------------------------------------------------


CREATE TABLE CRM_Turnos_Pre_Tipos_Sectores(
	Id_Turno_Pre_Tipo_Sec   SMALLINT IDENTITY(1,1) NOT NULL,
	Id_Turno_Pre_Tipo		SMALLINT,
	Id_Sector				SMALLINT,
	 CONSTRAINT PK_CTurPTS_PorId PRIMARY KEY CLUSTERED (Id_Turno_Pre_Tipo)
)
GO

CREATE UNIQUE INDEX IX_CTurPTS_PorTipoSec ON CRM_Turnos_Pre_Tipos_Sectores
	(Id_Turno_Pre_Tipo ASC, Id_Sector ASC)
GO

ALTER TABLE CRM_Turnos_Pre_Tipos_Sectores		
	ADD CONSTRAINT FK_CTurPTS_Sectores FOREIGN KEY(Id_Sector)
	REFERENCES Empresas_Sedes_Sectores (Id_Sector)
GO

ALTER TABLE CRM_Turnos_Pre_Tipos_Sectores		
	ADD CONSTRAINT FK_CTurPTS_Tipos FOREIGN KEY(Id_Turno_Pre_Tipo)
	REFERENCES CRM_Turnos_Pre_Tipos (Id_Turno_Pre_Tipo)
GO

----------------------------------------------------------------------------------


CREATE TABLE CRM_Turnos_Presencial(
	Id_Turno_Pre		BIGINT IDENTITY(1,1) NOT NULL,
	Nro					VARCHAR(10),
	Fecha				DATETIME,
	Doc_Nro				VARCHAR(12),
	Id_Cliente			INT,
	Id_Turno_Pre_Tipo	SMALLINT,
	Id_Turno_Pre_Disp	SMALLINT,
	Id_Usuario			SMALLINT,
	Fecha_Inicio		DATETIME,
	Fecha_Fin			DATETIME,
	Estado				CHAR(1),         --(Pendiente | En proceso | Finalizado | Ausente | Cancelado)
	Nota				TEXT,
	CONSTRAINT PK_CTurP_PorId PRIMARY KEY CLUSTERED (	Id_Turno_Pre ASC)
)
GO


CREATE INDEX IX_CTurP_PorNro ON CRM_Turnos_Presencial
	(Nro ASC)
GO

CREATE INDEX IX_CTurP_PorDoc ON CRM_Turnos_Presencial
	(Doc_Nro ASC)
GO

CREATE INDEX IX_CTurP_PorCli ON CRM_Turnos_Presencial
	(Id_Cliente ASC)
GO

CREATE INDEX IX_CTurP_PorTipo ON CRM_Turnos_Presencial
	(Id_Turno_Pre_Tipo ASC)
GO

CREATE INDEX IX_CTurP_PorDisp ON CRM_Turnos_Presencial
	(Id_Turno_Pre_Disp ASC)
GO

CREATE INDEX IX_CTurP_PorUser ON CRM_Turnos_Presencial
	(Id_Usuario ASC)
GO

ALTER TABLE CRM_Turnos_Presencial		
	ADD CONSTRAINT FK_CTurP_Clientes FOREIGN KEY(Id_Cliente)
	REFERENCES Clientes (Id_Cliente)
GO

ALTER TABLE CRM_Turnos_Presencial		
	ADD CONSTRAINT FK_CTurP_Tipos FOREIGN KEY(Id_Turno_Pre_Tipo)
	REFERENCES CRM_Turnos_Pre_Tipos (Id_Turno_Pre_Tipo)
GO

ALTER TABLE CRM_Turnos_Presencial		
	ADD CONSTRAINT FK_CTurP_Dispositivos FOREIGN KEY(Id_Turno_Pre_Disp)
	REFERENCES CRM_Turnos_Pre_Dispositivos (Id_Turno_Pre_Disp)
GO

ALTER TABLE CRM_Turnos_Presencial		
	ADD CONSTRAINT FK_CTurP_Users FOREIGN KEY(Id_Usuario)
	REFERENCES Seg_User ([No])
GO
